return Def.ActorFrame{
	-- single
	Def.ActorFrame{
		Name="DeadSingle";
		BeginCommand=function(self)
			local style = GAMESTATE:GetCurrentStyle()
			local styleType = style:GetStyleType()
			self:visible( (styleType ~= "StyleType_OnePlayerTwoSides" and styleType ~= "StyleType_TwoPlayersSharedSides") and (GAMESTATE:PlayerIsUsingModifier(PLAYER_1,"battery") == false or GAMESTATE:PlayerIsUsingModifier(PLAYER_2,"battery") == false) )
		end;
		HealthStateChangedMessageCommand=function(self, param)
			if param.HealthState == "HealthState_Dead" then
				local dead = self:GetChild("Dead"..ToEnumShortString(param.PlayerNumber))
				dead:playcommand("Show")
			end
		end;
		Def.Quad{
			Name="DeadP1";
			InitCommand=cmd(diffuse,color("1,0,0,0.5");faderight,0.3;stretchto,SCREEN_LEFT,SCREEN_TOP,SCREEN_CENTER_X,SCREEN_BOTTOM;diffusealpha,0;player,PLAYER_1);
			ShowCommand=cmd(linear,0.2;diffusealpha,0.5);
		};
		Def.Quad{
			Name="DeadP2";
			InitCommand=cmd(diffuse,color("1,0,0,0.5");fadeleft,0.3;stretchto,SCREEN_CENTER_X,SCREEN_TOP,SCREEN_RIGHT,SCREEN_BOTTOM;diffusealpha,0;player,PLAYER_2);
			ShowCommand=cmd(linear,0.2;diffusealpha,0.5);
		};
	};

	-- double
	Def.ActorFrame{
		Name="DeadDouble";
		BeginCommand=function(self)
			local style = GAMESTATE:GetCurrentStyle()
			local styleType = style:GetStyleType()
			self:visible( (styleType == "StyleType_OnePlayerTwoSides" or styleType == "StyleType_TwoPlayersSharedSides") and (GAMESTATE:PlayerIsUsingModifier(PLAYER_1,"battery") == false or GAMESTATE:PlayerIsUsingModifier(PLAYER_2,"battery") == false) )
		end;
		HealthStateChangedMessageCommand=function(self, param)
			if param.HealthState == "HealthState_Dead" then
				self:RunCommandsOnChildren(cmd(playcommand,"Show"))
			end
		end;
		Def.Quad{
			InitCommand=cmd(diffuse,color("1,0,0,0.5");fadeleft,0.2;faderight,0.2;FullScreen;diffusealpha,0);
			ShowCommand=cmd(linear,0.2;diffusealpha,0.5);
		};
	};
};